using System;
using System.Web;
using System.Web.Management;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Collections.Generic;
using System.Text;

namespace SampleEvents
{
   public class SearchWebEventProvider : BufferedWebEventProvider
   {
      public override void ProcessEvent(WebBaseEvent eventRaised)
      {
         if (UseBuffering)
            base.ProcessEvent(eventRaised);
         else
            DispatchEvent((AsyncSearchWebEvent)eventRaised);
      }

      public override void ProcessEventFlush(WebEventBufferFlushInfo flushInfo)
      {
         foreach (WebBaseEvent evt in flushInfo.Events)
         {
            DispatchEvent((AsyncSearchWebEvent)evt);
         }
      }

      public void DispatchEvent(AsyncSearchWebEvent webEvent)
      {
         // skorzystaj z tej metody, aby zadecydowa czy zdarzenie powinno
         // zosta wysane do wyszukiwania automatycznego,
         // czy te do osoby wyszukujcej (wylij do kolejki roboczej)
      }
   }
}
